/*
 * Decompiled with CFR 0.152.
 */
package flash.io;

import flash.io.BitInput;
import flash.io.BitLibrary;
import flash.io.FlashFilter;
import flash.io.TagReader;
import flash.io.TypeReader;
import flash.objects.FMovie;
import flash.objects.FRect;
import java.io.File;
import java.io.FileInputStream;

public class FlashReader {
    private BitInput bi;
    private BitLibrary bl;
    private boolean open;
    private TagReader myTagReader;
    private TypeReader myTypeReader;
    private FlashFilter myFilter;
    private String myError = null;
    private int myMaxFrame = -1;

    public FlashReader(File file, FlashFilter flashFilter) {
        try {
            this.myFilter = flashFilter;
            this.bi = new BitInput(new FileInputStream(file));
            this.bl = new BitLibrary(this.bi);
            this.open = true;
        }
        catch (Exception exception) {
            this.open = false;
        }
    }

    public void setMaxFrame(int n) {
        this.myMaxFrame = n;
    }

    public boolean ready() {
        return this.open;
    }

    public void close() {
        try {
            this.open = false;
            this.bi.close();
            this.bi = null;
            this.bl = null;
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    public FMovie parse() throws Exception {
        String string;
        String string2 = (char)this.bl.ui8() + "" + (char)this.bl.ui8() + (char)this.bl.ui8();
        FMovie fMovie = null;
        int n = (int)this.bl.ui8();
        long l = this.bl.ui32();
        if (string2.equals("CWS")) {
            this.bi.useCompressedStream();
        }
        this.myTypeReader = new TypeReader(this.bl, this.bi, n);
        FRect fRect = this.myTypeReader.rect();
        float f = (float)this.bl.ui16() / 256.0f;
        long l2 = this.bl.ui16();
        fMovie = new FMovie(string2, n, l, fRect, f, l2);
        this.myTagReader = new TagReader(this.myTypeReader, this.bl, this.bi, fMovie.getVersion(), this.myFilter);
        if (this.myMaxFrame != -1) {
            this.myTagReader.setMaxFrame(this.myMaxFrame);
        }
        if ((string = this.myTagReader.parseTags(fMovie, fMovie.getFileLength(), 0)) != null) {
            this.myError = string;
            return null;
        }
        return fMovie;
    }

    public String getError() {
        return this.myError;
    }
}

